function [data] = totalnum_count(dir_tmp)
%This function takes asks you to open a bunch of vertices files and gives
%you a count of the number of vertices in them.
%Synatax:   [data] = totalnum_count();
%Input:     dir_tmp = the directory of interest
%Output:    data = the total numbers data structure

%where are the files?
if nargin==0
    dir_tmp = uigetdir2('','Directory where the files are located');    %get the directory
end

%now grab the collated interested vert files
[verts] = process_files(dir_tmp);

idx = 0;    %initiate the file count idx
for i = 1:size(verts,2)     %go through the number of unique sets
    vert_tmp = verts{i};
    for j = 1:size(vert_tmp,1)  %now get through the files
        filename_tmp = vert_tmp{j};     %pull out the first file
        idx = idx+1;    %up 1
        filenames{idx} = strtrim(filename_tmp(1:end-4));    %store the name for labeling purposes
        %now open up the file and calcualte the count
        content = single(dlmread([dir_tmp,'\',filename_tmp],',',1,0));
        data(idx) = size(content,1);  %the count
    end 
end

%now output
data_out = dataset({data,filenames{:}},'ObsNames',{'count'});
sav2csv(data_out,'total_num_count.csv',dir_tmp);

%--------------------------------------------------------------------------
%subfunction to seperate files from directories
function [verts] = process_files(dir_tmp)

dir_struct = dir(dir_tmp);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root

%get the files
try
list = names(~idx);
catch
    keyboard
end
%filter for only the files we want
verts_idx = ones(size(list));   %create an index for selecting the flat files
for j = 1:size(list,2)
    %the only files we care about are the flat rotated vertices and the properties for now
    if ~strcmp('vert',list{j}(1:4))
        verts_idx(j) = 0;    %set this for removal
    end
end
%create the desired lists of file names.
verts = list(logical(verts_idx));    %list for flat vertices files
if isempty(verts)    %if there are no verts, lets check if these are the original verts files
    verts_idx = ones(size(list));   %create an index for selecting the flat files
    %first grab all the csv files
    for k = 1:size(list,2)
        if ~strcmp('csv',list{k}(end-2:end))
            verts_idx(k) = 0;    %set this for removal
        end
    end
    verts = list(logical(verts_idx));   %grab all of the csv files
    %filter again to see if it meets criteria
    for l = 1:size(verts,2)
        filename_tmp = verts{l};
        strmask2 = isstrprop(filename_tmp,'digit');  %find the numbers, we only want the first two
        if strmask2(1)&&strmask2(end-4)     %numbers at the start and the end go
            strmask = isstrprop(filename_tmp,'wspace');  %find the punctuations, we only want the first two
            [x,y] = find(strmask==1);  %get the positions
            %if strcmp('csv',filename_tmp(i,y(end)+1:y(end)+3))  %we only care about the csv files for now.
            f_tmp{l,:} = filename_tmp(y(1)+1:y(2)-1);    %create an array of the words
        end
    end
    uq_names = unique(f_tmp);    %how many unique words are there
    for n = 1:size(uq_names,1)      %step through unique names
        itr = 1;
        for m = 1:size(f_tmp,1)     %step through the all file names
            if strcmpi(uq_names(n,:),f_tmp(m,:)) %if there is a match (case insensitive now)
                tmp{itr} = verts{m};  %put it in the current file names temp
                itr = itr+1;
            end
        end
        vert_tmp{n} = tmp;  %cell of cells, each cell contains a package of same filenames
        clear tmp
    end
    verts = vert_tmp;   %output
else    %still in verts mode, now collate the files
    for k = 1:size(verts,2)      %step through each filename and pull the wanted word
        filename_tmp = verts{k};
        strmask = isstrprop(filename_tmp,'punct');  %find the punctuations, we only want the first two
        [x,y] = find(strmask==1);  %get the positions
        %if strcmp('csv',filename_tmp(i,y(end)+1:y(end)+3))  %we only care about the csv files for now.
        f_tmp{k,:} = filename_tmp(y(1)+1:y(2)-1);    %create an array of the words
        %end
    end
    uq_names = unique(f_tmp);    %how many unique words are there
    for l = 1:size(uq_names,1)      %step through unique names
        itr = 1;
        for m = 1:size(f_tmp,1)     %step through the all file names
            if strcmpi(uq_names(l,:),f_tmp(m,:)) %if there is a match (case insensitive now)
                tmp{itr} = verts{m};  %put it in the current file names temp
                itr = itr+1;
            end
        end
        vert_tmp{l} = tmp;  %cell of cells, each cell contains a package of same filenames
        clear tmp
    end
    verts = vert_tmp;   %output
end